/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;

public abstract class WaitDialog
extends AbstractDialog {
    private long timeout = 60000L;
    private int steps = 1000;
    private Thread t = null;

    public WaitDialog(int pos) {
        this(-1L, pos);
    }

    public WaitDialog(long timeout, int pos) {
        super(pos);
        if (timeout >= 5000L) {
            this.timeout = timeout;
        }
        super.addCloseListener(new Listener(){

            public void handleEvent(Event event) {
                if (WaitDialog.this.t != null) {
                    try {
                        WaitDialog.this.t.interrupt();
                    }
                    catch (OperationCanceledException oce) {
                        throw oce;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected Object getData() throws Exception {
        return null;
    }

    public String getText() {
        return null;
    }

    protected abstract boolean check();

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        String text = this.getText();
        if (text != null && text.length() > 0) {
            container.addText(text, true);
        }
        final ProgressBar bar = new ProgressBar(((Container)container).getComposite(), 65536);
        GridData g = new GridData(768);
        g.horizontalSpan = 2;
        bar.setLayoutData((Object)g);
        bar.setMaximum(this.steps);
        bar.setSelection(0);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton("  " + this.i18n.tr("OK") + "  ", new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                WaitDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException("operation cancelled");
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
        this.t = new Thread(){

            @Override
            public void run() {
                try {
                    long wait = 200L;
                    long chunks = WaitDialog.this.timeout / 200L;
                    final int step = (int)((long)WaitDialog.this.steps / chunks);
                    final AtomicInteger pos = new AtomicInteger(0);
                    while (pos.intValue() <= WaitDialog.this.steps) {
                        if (WaitDialog.this.check()) {
                            WaitDialog.this.close();
                            return;
                        }
                        GUI.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (bar != null && !bar.isDisposed()) {
                                    pos.set(bar.getSelection() + step);
                                    bar.setSelection(pos.get());
                                }
                            }
                        });
                        4.sleep(200L);
                    }
                    GUI.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            throw new OperationCanceledException("operation cancelled/timed out");
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.t.start();
    }
}

